/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.wrapper;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.tools.ventilation.VentilationUtils;
import net.desmodo.atlas.ventilation.VentilationFactory;
import net.desmodo.atlas.ventilation.VentilationName;
import net.desmodo.atlas.wrapper.AbstractComboBoxModel;
import net.desmodo.atlas.wrapper.GroupeItem;
import net.desmodo.atlas.wrapper.GroupeItemManager;
import net.desmodo.atlas.wrapper.VentilationNameItem;
import net.desmodo.atlas.wrapper.VentilationNameItemImpl;
import net.desmodo.atlas.wrapper.VentilationNameItemManager;
import net.mapeadores.util.awt.ColorSkin;
import net.mapeadores.util.localisation.Lang;

class VentilationNameItemManagerImpl
implements VentilationNameItemManager {
    private final Atlas atlas;
    private final VentilationNameItemImpl ventilationNaturelleVentilationNameItem;
    private final VentilationNameItemImpl ventilationCompleteVentilationNameItem;
    private final VentilationNameItemImpl ventilationByFamilleVentilationNameItem;
    private final Map<VentilationName, VentilationNameItem> ventilationNameItemMap = new HashMap<VentilationName, VentilationNameItem>();
    private final ColorSkin blackColorSkin = new ColorSkin("special:black", Color.BLACK, Color.WHITE, Color.WHITE, Color.DARK_GRAY);
    private final GroupeItemManager groupeItemManager;
    private final VentilationNameItemListModel ventilationNameItemListModel;

    VentilationNameItemManagerImpl(Atlas atlas, Lang lang, GroupeItemManager groupeItemManager, VentilationFactory ventilationFactory) {
        this.groupeItemManager = groupeItemManager;
        this.atlas = atlas;
        this.ventilationNaturelleVentilationNameItem = this.createStaticVentilationNameItem(VentilationName.VENTILATION_NATURELLE, lang);
        this.putVentilationNameItem(this.ventilationNaturelleVentilationNameItem);
        this.ventilationCompleteVentilationNameItem = this.createStaticVentilationNameItem(VentilationName.VENTILATION_COMPLETE, lang);
        this.putVentilationNameItem(this.ventilationCompleteVentilationNameItem);
        this.ventilationByFamilleVentilationNameItem = this.createStaticVentilationNameItem(VentilationName.VENTILATION_BYFAMILLE, lang);
        this.putVentilationNameItem(this.ventilationByFamilleVentilationNameItem);
        this.ventilationNameItemListModel = new VentilationNameItemListModel();
    }

    private VentilationNameItemImpl createStaticVentilationNameItem(VentilationName ventilationName, Lang lang) {
        VentilationNameItemImpl ventilationNameItem = new VentilationNameItemImpl(ventilationName);
        ventilationNameItem.setProfondeur(0);
        ventilationNameItem.setColorSkin(this.blackColorSkin);
        ventilationNameItem.setString(VentilationUtils.getStaticVentilationLocalizedString(lang, ventilationName));
        return ventilationNameItem;
    }

    private void putVentilationNameItem(VentilationNameItem ventilationNameItem) {
        this.ventilationNameItemMap.put(ventilationNameItem.getVentilationName(), ventilationNameItem);
    }

    private void removeVentilationNameItem(VentilationNameItem ventilationNameItem) {
        this.ventilationNameItemMap.remove(ventilationNameItem.getVentilationName());
    }

    private VentilationNameItem createVentilationNameItem(GroupeItem groupeItem) {
        VentilationName ventilationName = new VentilationName("ventilation", null, this.atlas.getTerm(groupeItem.getTermCode()));
        VentilationNameItemImpl ventilationNameItem = new VentilationNameItemImpl(ventilationName);
        int profondeur = 0;
        for (GroupeItem parent = groupeItem.getGroupeParent(); parent != null; parent = parent.getGroupeParent()) {
            ++profondeur;
        }
        if (groupeItem.getTermType() == 4) {
            --profondeur;
        }
        ventilationNameItem.setProfondeur(profondeur);
        ventilationNameItem.setString(groupeItem.toString());
        ventilationNameItem.setColorSkin(groupeItem.getColorSkin());
        ventilationNameItem.setActive(groupeItem.isActive());
        this.putVentilationNameItem(ventilationNameItem);
        return ventilationNameItem;
    }

    @Override
    public ListModel getVentilationNameItemListModel() {
        return this.ventilationNameItemListModel;
    }

    @Override
    public VentilationNameItem getVentilationNameItem(VentilationName ventilationName) {
        return this.ventilationNameItemMap.get(ventilationName);
    }

    private class VentilationNameItemListModel
    extends AbstractComboBoxModel {
        private final List<VentilationNameItem> ventilationNameItemList = new ArrayList<VentilationNameItem>();
        private final ListModel eligibleFamilleListModel;
        private final ListModel eligibleGrilleAndContexteListModel;
        private final EligibleListener grilleAndContexteListener = new EligibleListener(false);
        private final EligibleListener familleListener = new EligibleListener(true);

        private VentilationNameItemListModel() {
            GroupeItem groupeitem;
            int i;
            this.ventilationNameItemList.add(VentilationNameItemManagerImpl.this.ventilationNaturelleVentilationNameItem);
            this.ventilationNameItemList.add(VentilationNameItemManagerImpl.this.ventilationCompleteVentilationNameItem);
            this.eligibleGrilleAndContexteListModel = VentilationNameItemManagerImpl.this.groupeItemManager.getGroupeItemListModel((short)7);
            for (i = 0; i < this.eligibleGrilleAndContexteListModel.getSize(); ++i) {
                groupeitem = (GroupeItem)this.eligibleGrilleAndContexteListModel.getElementAt(i);
                this.ventilationNameItemList.add(VentilationNameItemManagerImpl.this.createVentilationNameItem(groupeitem));
            }
            this.eligibleGrilleAndContexteListModel.addListDataListener(this.grilleAndContexteListener);
            this.eligibleFamilleListModel = VentilationNameItemManagerImpl.this.groupeItemManager.getGroupeItemListModel((short)6);
            for (i = 0; i < this.eligibleFamilleListModel.getSize(); ++i) {
                groupeitem = (GroupeItem)this.eligibleFamilleListModel.getElementAt(i);
                this.ventilationNameItemList.add(VentilationNameItemManagerImpl.this.createVentilationNameItem(groupeitem));
            }
            this.eligibleFamilleListModel.addListDataListener(this.familleListener);
            this.ventilationNameItemList.add(VentilationNameItemManagerImpl.this.ventilationByFamilleVentilationNameItem);
        }

        @Override
        public Object getElementAt(int index) {
            return this.ventilationNameItemList.get(index);
        }

        @Override
        public int getSize() {
            return this.ventilationNameItemList.size();
        }

        private class EligibleListener
        implements ListDataListener {
            private final boolean isFamille;

            private EligibleListener(boolean b) {
                this.isFamille = b;
            }

            private int getDecalage() {
                if (this.isFamille) {
                    return 1 + VentilationNameItemListModel.this.eligibleGrilleAndContexteListModel.getSize();
                }
                return 1;
            }

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
                int decalage = this.getDecalage();
                ListModel listModel = this.isFamille ? VentilationNameItemListModel.this.eligibleFamilleListModel : VentilationNameItemListModel.this.eligibleGrilleAndContexteListModel;
                for (int i = listDataEvent.getIndex0(); i <= listDataEvent.getIndex1(); ++i) {
                    GroupeItem groupeItem = (GroupeItem)listModel.getElementAt(i);
                    VentilationNameItem ventilationNameItem = VentilationNameItemManagerImpl.this.createVentilationNameItem(groupeItem);
                    VentilationNameItemListModel.this.ventilationNameItemList.set(i + decalage, ventilationNameItem);
                }
                VentilationNameItemListModel.this.fireContentsChanged(this, listDataEvent.getIndex0() + decalage, listDataEvent.getIndex1() + decalage);
            }

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
                int decalage = this.getDecalage();
                ListModel listModel = this.isFamille ? VentilationNameItemListModel.this.eligibleFamilleListModel : VentilationNameItemListModel.this.eligibleGrilleAndContexteListModel;
                for (int i = listDataEvent.getIndex0(); i <= listDataEvent.getIndex1(); ++i) {
                    GroupeItem groupeItem = (GroupeItem)listModel.getElementAt(i);
                    VentilationNameItem ventilationNameItem = VentilationNameItemManagerImpl.this.createVentilationNameItem(groupeItem);
                    VentilationNameItemListModel.this.ventilationNameItemList.add(i + decalage, ventilationNameItem);
                }
                VentilationNameItemListModel.this.fireIntervalAdded(this, listDataEvent.getIndex0() + decalage, listDataEvent.getIndex1() + decalage);
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
                int index1;
                int decalage = this.getDecalage();
                int index0 = listDataEvent.getIndex0() + decalage;
                for (int i = index1 = listDataEvent.getIndex1() + decalage; i >= index0; --i) {
                    VentilationNameItem ventilationNameItem = (VentilationNameItem)VentilationNameItemListModel.this.ventilationNameItemList.remove(i);
                    VentilationNameItemManagerImpl.this.removeVentilationNameItem(ventilationNameItem);
                }
                VentilationNameItemListModel.this.fireIntervalRemoved(this, index0, index1);
            }
        }
    }
}

