/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.tools.multilist;

import net.desmodo.atlas.tools.multilist.MultiList;
import net.mapeadores.util.primitives.BitmaskUtils;

public abstract class MultiListItem {
    private int primaryIndex = -1;
    private int[] secondaryIndex;
    private int mask = 0;
    private MultiList multiList = null;

    public MultiListItem(MultiList multiList, int initialmask) {
        this.mask = initialmask;
        if (multiList != null) {
            multiList.add(this);
        } else {
            this.clear();
        }
    }

    public final int getPrimaryIndex() {
        return this.primaryIndex;
    }

    public final int[] getSecondaryIndex() {
        int[] result = new int[this.secondaryIndex.length];
        System.arraycopy(this.secondaryIndex, 0, result, 0, this.secondaryIndex.length);
        return result;
    }

    public final int getMask() {
        return this.mask;
    }

    public final int getSecondaryListCount() {
        return this.secondaryIndex.length;
    }

    public final int getSecondaryIndex(int p) {
        return this.secondaryIndex[p];
    }

    public final boolean isCleared() {
        return this.multiList == null;
    }

    public final MultiList getMultiList() {
        return this.multiList;
    }

    public abstract Object getWrappedObject();

    void clear() {
        this.primaryIndex = -1;
        this.secondaryIndex = new int[0];
        this.multiList = null;
    }

    void setMultiList(MultiList multiList) {
        this.secondaryIndex = new int[multiList.getSecondaryListCount()];
        this.multiList = multiList;
    }

    void increaseSecondaryIndex(int p) {
        if (this.secondaryIndex[p] == -1) {
            throw new RuntimeException("decrease");
        }
        int n = p;
        this.secondaryIndex[n] = this.secondaryIndex[n] + 1;
    }

    void decreaseSecondaryIndex(int p) {
        if (this.secondaryIndex[p] == -1) {
            throw new RuntimeException("decrease");
        }
        int n = p;
        this.secondaryIndex[n] = this.secondaryIndex[n] - 1;
    }

    void decreasePrimaryIndex() {
        --this.primaryIndex;
    }

    void increasePrimaryIndex() {
        ++this.primaryIndex;
    }

    void setSecondaryIndex(int p, int i) {
        this.mask = i == -1 ? (this.mask &= ~BitmaskUtils.getBitValue((int)p)) : (this.mask |= BitmaskUtils.getBitValue((int)p));
        this.secondaryIndex[p] = i;
    }

    void setPrimaryIndex(int index) {
        this.primaryIndex = index;
    }
}

