/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.tools.attr;

import java.awt.Color;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.primitives.FuzzyDate;

public final class AtlasAttributeUtils {
    private AtlasAttributeUtils() {
    }

    public static boolean testAttribute(Attribute attribute, String formatType) {
        int valueLength = attribute.size();
        for (int i = 0; i < valueLength; ++i) {
            Object obj = AtlasAttributeUtils.formatValue((String)attribute.get(i), formatType);
            if (obj != null) continue;
            return false;
        }
        return true;
    }

    public static Object formatValue(String value, String formatType) {
        if (formatType.equals("color")) {
            try {
                return Color.decode(value);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        if (formatType.equals("url")) {
            try {
                return new URL(value);
            }
            catch (MalformedURLException mue) {
                return null;
            }
        }
        if (formatType.startsWith("integer")) {
            try {
                Integer itg = Integer.parseInt(value);
                if (formatType.equals("integer_positive") ? itg < 0 : formatType.equals("integer_strictpositive") && itg <= 0) {
                    return null;
                }
                return itg;
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        if (formatType.equals("datation")) {
            try {
                return FuzzyDate.parse((String)value);
            }
            catch (ParseException e) {
                return null;
            }
        }
        return value;
    }
}

