/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.textimport;

import net.desmodo.atlas.AtlasEditor;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.Grille;
import net.desmodo.atlas.structure.GrilleEditor;
import net.desmodo.atlas.textimport.AtlasLibImport;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.CleanedString;
import net.mapeadores.util.text.LabelUtils;

public class GrilleLibImport
extends AtlasLibImport {
    private GrilleEditor grilleEditor;
    private Grille grille;

    public GrilleLibImport(Lang[] langArray, AtlasEditor atlasEditor) {
        super(langArray, atlasEditor);
    }

    public void importValues(Grille grille, String[][] values) {
        int length = values.length;
        if (length == 0) {
            return;
        }
        this.grilleEditor = this.atlasEditor.getStructureEditor().getGrilleEditor(grille);
        this.grille = grille;
        this.atlasEditor.startCompoundEvent(this, "grilleLibImport");
        for (int i = 0; i < length; ++i) {
            String[] line = values[i];
            if (line.length <= 0) continue;
            this.importLine(line);
        }
        this.atlasEditor.endCompoundEvent(this, "grilleLibImport");
    }

    private void importLine(String[] line) {
        String idctxt = line[0];
        Contexte contexte = this.grille.getContexteByIdctxt(idctxt);
        if (contexte != null) {
            int langLng = this.langArray.length;
            int lineLng = line.length - 1;
            for (int i = 0; i < langLng; ++i) {
                if (i >= lineLng) continue;
                String value = line[i + 1];
                Lang lang = this.langArray[i];
                CleanedString cleanedString = CleanedString.newInstance((CharSequence)value);
                if (cleanedString == null) {
                    this.atlasEditor.removeLibelle(contexte, lang);
                    continue;
                }
                this.atlasEditor.putLibelle(contexte, LabelUtils.toLabel((Lang)lang, (CleanedString)cleanedString));
            }
        }
    }
}

