/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.sxio;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.desmodo.atlas.sxio.SXIOException;
import net.desmodo.atlas.sxio.SXStylesSource;

public class StringSXStylesSource
implements SXStylesSource {
    String stylesBody;

    public StringSXStylesSource(String stylesBody) {
        this.stylesBody = stylesBody;
    }

    @Override
    public String getEncoding() {
        return "UTF-8";
    }

    @Override
    public void writeStyles(OutputStream outputStream) throws SXIOException {
        try (ByteArrayInputStream input = new ByteArrayInputStream(this.stylesBody.getBytes(this.getEncoding()));){
            int n;
            byte[] buffer = new byte[1004];
            while ((n = input.read(buffer)) != -1) {
                outputStream.write(buffer, 0, n);
            }
        }
        catch (IOException ioe) {
            throw new SXIOException(ioe);
        }
    }
}

