/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.session;

import java.util.Set;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.conf.Conf;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.liens.Lien;
import net.desmodo.atlas.liens.LienHierarchique;
import net.desmodo.atlas.liens.LienStructurel;
import net.desmodo.atlas.liens.LienSymetrique;
import net.desmodo.atlas.liens.LiensFilter;
import net.desmodo.atlas.session.SessionUtils;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.ventilation.Liaison;
import net.desmodo.atlas.ventilation.LiaisonFilter;

public class ConfLiaisonFilter
implements LiaisonFilter {
    private final Conf conf;
    private final Atlas atlas;
    private Set<Integer> famillesLimitationSet;
    private LiensFilter lienFilter;
    private boolean isActive = false;

    public ConfLiaisonFilter(Atlas atlas, Conf conf) {
        this.atlas = atlas;
        this.conf = conf;
        this.innerReinit();
    }

    public void reinit() {
        this.innerReinit();
    }

    private void innerReinit() {
        boolean limitFamilles = this.conf.getBoolean("limitation.familles");
        this.famillesLimitationSet = !limitFamilles ? null : SessionUtils.getFamillesLimitationSet(this.conf, this.atlas.getStructure());
        boolean limitLiens = this.conf.getBoolean("limitation.liens");
        this.lienFilter = !limitLiens ? null : SessionUtils.getLienFilter(this.conf);
        this.isActive = limitFamilles || limitLiens;
    }

    @Override
    public boolean accept(Liaison liaison) {
        Term term;
        if (this.famillesLimitationSet != null && (term = liaison.getTerm()) instanceof Descripteur && !this.famillesLimitationSet.contains(((Descripteur)term).getFamille().getCode())) {
            return false;
        }
        if (this.lienFilter != null) {
            Lien lien = liaison.getLien();
            if (lien instanceof LienHierarchique) {
                if (((LienHierarchique)lien).getDescripteurPere().equals(liaison.getTerm())) {
                    return this.lienFilter.acceptLienHierarchiqueAmont();
                }
                return this.lienFilter.acceptLienHierarchiqueAval();
            }
            if (lien instanceof LienSymetrique) {
                return this.lienFilter.acceptLienSymetrique();
            }
            if (lien instanceof LienStructurel && liaison.getTerm() instanceof Contexte) {
                return this.lienFilter.acceptLienStructurel();
            }
        }
        return true;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }
}

