/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.display.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.border.Border;
import net.desmodo.atlas.boxes.BoxSkin;
import net.desmodo.atlas.boxes.TextBox;
import net.desmodo.atlas.display.CommonDisplay;
import net.desmodo.atlas.display.GraphicsUtils;
import net.desmodo.atlas.display.blocks.LibelleBlock;
import net.desmodo.atlas.display.components.HighlightBorder;
import net.desmodo.atlas.display.overflow.Overflow;

public class TextBoxComponent
extends JComponent {
    private TextBox textBox;
    private BoxSkin boxSkin;
    private int transx;
    private int transy;
    private Color forcedBackgroundColor = null;

    public TextBoxComponent(Border border) {
        this.setVisible(false);
        this.setBorder(border);
    }

    private void setForcedBackgroundColor(Color forcedBackgroundColor) {
        this.forcedBackgroundColor = forcedBackgroundColor;
    }

    public void dispose() {
        this.textBox = null;
        this.setVisible(false);
    }

    public void redim() {
        Border border = this.getBorder();
        Insets insets = border != null ? border.getBorderInsets(this) : this.getInsets();
        Dimension dim = this.textBox.getDimension();
        Dimension newdim = new Dimension(dim.width + insets.left + insets.right, dim.height + insets.top + insets.bottom);
        this.transx = insets.left;
        this.transy = insets.top;
        this.setSize(newdim);
    }

    public void setLibelleBlock(LibelleBlock libelleBlock, Overflow overflow) {
        if (libelleBlock == null) {
            this.dispose();
        } else {
            this.setTextBox(libelleBlock.getTextBox());
            Point P = libelleBlock.getLocation();
            this.moveTo(P.x + overflow.getWestOverflow(), P.y + overflow.getNorthOverflow());
        }
    }

    public void setTextBox(TextBox textBox) {
        if (textBox == null) {
            this.dispose();
        } else {
            this.textBox = textBox;
            this.boxSkin = textBox.getBoxSkin();
            this.redim();
        }
    }

    public void moveTo(Point P) {
        if (P == null) {
            this.dispose();
        } else {
            this.setLocation(P.x - this.transx, P.y - this.transy);
            this.setVisible(true);
        }
    }

    public void moveTo(int x, int y) {
        this.setLocation(x - this.transx, y - this.transy);
        this.setVisible(true);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.textBox != null) {
            if (this.forcedBackgroundColor != null) {
                g.setColor(this.forcedBackgroundColor);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            CommonDisplay.paint(this.textBox, this.boxSkin, (Graphics2D)g, new Point(this.transx, this.transy));
        }
    }

    public static TextBoxComponent createFocusedBordureTextBoxComponent() {
        TextBoxComponent comp = new TextBoxComponent(new FocusBorder(Color.RED));
        comp.setForcedBackgroundColor(Color.WHITE);
        return comp;
    }

    public static TextBoxComponent createMovingTextBoxComponent() {
        return new TextBoxComponent(new HighlightBorder(Color.RED));
    }

    private static class FocusBorder
    implements Border {
        private final int dotsize = 1;
        private final Color color;

        private FocusBorder(Color color) {
            this.color = color;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(2, 1, 2, 1);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color oldColor = g.getColor();
            g.setColor(Color.WHITE);
            GraphicsUtils.drawHorizontalLine(g, x, y, width);
            GraphicsUtils.drawHorizontalLine(g, x, y + height - 1, width);
            g.drawRect(x, y, width - 1, height - 1);
            g.drawRect(x, y + 1, width - 1, height - 3);
            g.setColor(this.color);
            GraphicsUtils.drawDottedHorizontalLine(g, x, y + 1, width, 1);
            GraphicsUtils.drawDottedHorizontalLine(g, x, y + height - 2, width, 1);
            g.setColor(oldColor);
        }
    }
}

