/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.comptaexemole;

import fr.exemole.bdfext.comptaexemole.LigneError;
import fr.exemole.bdfext.comptaexemole.ParseResult;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.fichotheque.corpus.FicheMeta;
import net.mapeadores.util.html.HtmlProducer;
import net.mapeadores.util.html.PageHtmlPrinter;
import net.mapeadores.util.localisation.Lang;

public class ResultPage
extends PageHtmlPrinter
implements HtmlProducer {
    private static final Lang DEFAULT_LANG = Lang.build((String)"fr");
    private List<LigneError> errorList;
    private ParseResult parseResult;

    public ResultPage(List<LigneError> errorList) {
        this.errorList = errorList;
    }

    public ResultPage(ParseResult parseResult) {
        this.parseResult = parseResult;
    }

    public void writeHtml(Appendable writer) throws IOException {
        this.initPrinter(writer);
        this.start(DEFAULT_LANG, "R\u00e9sultat de l'importation");
        if (this.parseResult != null) {
            this.printParseResult();
        } else {
            this.printErrorList();
        }
        this.end();
    }

    private void printErrorList() {
        this.H2().__escape((CharSequence)"Erreur dans le fichier : aucun enregistrement n'a \u00e9t\u00e9 mis \u00e0 jour")._H2();
        for (LigneError ligneError : this.errorList) {
            this.printLigneError(ligneError);
        }
    }

    private void printLigneError(LigneError ligneError) {
        this.P().__escape((CharSequence)("Ligne " + ligneError.getNumero() + " : ")).__escape((CharSequence)ligneError.getMessage())._P();
        this.TABLE();
        String[] ligne1 = ligneError.getLigne1();
        this.printRow(ligne1);
        String[] ligne2 = ligneError.getLigne2();
        if (ligne2 != null) {
            this.printRow(ligne2);
        }
        this._LI()._TABLE();
    }

    private void printParseResult() {
        this.H2().__escape((CharSequence)"Lignes ajout\u00e9es :")._H2();
        this.printMap(this.parseResult.getAjoutMap());
        this.H2().__escape((CharSequence)"Lignes mises \u00e0 jour :")._H2();
        this.printMap(this.parseResult.getMajMap());
        this.printAbsentMap(this.parseResult.getAbsentMap());
    }

    private void printMap(Map<String, String[]> ligneMap) {
        this.TABLE();
        for (String[] ligne : ligneMap.values()) {
            this.printRow(ligne);
        }
        this._TABLE();
    }

    private void printAbsentMap(Map<String, FicheMeta> absentMap) {
        if (absentMap.isEmpty()) {
            this.H2().__escape((CharSequence)"Aucune ligne \u00e0 supprimer")._H2();
        } else {
            this.H2().__escape((CharSequence)"Ligne \u00e0 supprimer")._H2();
            this.UL();
            for (FicheMeta ficheMeta : absentMap.values()) {
                this.LI().P().__append(ficheMeta.getId()).__escape((CharSequence)" : ").__escape((CharSequence)ficheMeta.getTitre())._P()._LI();
            }
            this._UL();
        }
    }

    private void printRow(String[] ligne) {
        this.TR();
        for (String token : ligne) {
            this.TD().__escape((CharSequence)token)._TD();
        }
        this._TR();
    }
}

