/*
 * Decompiled with CFR 0.152.
 */
package com.Ostermiller.util;

import com.Ostermiller.util.BadDelimiterException;
import com.Ostermiller.util.BadQuoteException;
import com.Ostermiller.util.CSVPrint;
import com.Ostermiller.util.StringHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;

public class ExcelCSVPrinter
implements CSVPrint {
    protected boolean autoFlush = true;
    protected boolean alwaysQuote = false;
    protected boolean error = false;
    protected char delimiterChar = (char)44;
    protected char quoteChar = (char)34;
    protected Writer out;
    protected boolean newLine = true;

    public ExcelCSVPrinter(OutputStream out) {
        this.out = new OutputStreamWriter(out);
    }

    public ExcelCSVPrinter(Writer out) {
        this.out = out;
    }

    public ExcelCSVPrinter(Writer out, boolean alwaysQuote, boolean autoFlush) {
        this.out = out;
        this.setAlwaysQuote(alwaysQuote);
        this.setAutoFlush(autoFlush);
    }

    public ExcelCSVPrinter(Writer out, char quote, char delimiter) throws BadDelimiterException, BadQuoteException {
        this.out = out;
        this.changeQuote(quote);
        this.changeDelimiter(delimiter);
    }

    public ExcelCSVPrinter(Writer out, char quote, char delimiter, boolean alwaysQuote, boolean autoFlush) throws BadDelimiterException, BadQuoteException {
        this.out = out;
        this.changeQuote(quote);
        this.changeDelimiter(delimiter);
        this.setAlwaysQuote(alwaysQuote);
        this.setAutoFlush(autoFlush);
    }

    @Override
    public void changeDelimiter(char newDelimiter) throws BadDelimiterException {
        if (this.delimiterChar == newDelimiter) {
            return;
        }
        if (newDelimiter == '\n' || newDelimiter == '\r' || newDelimiter == this.delimiterChar || newDelimiter == this.quoteChar) {
            throw new BadDelimiterException();
        }
        this.delimiterChar = newDelimiter;
    }

    @Override
    public void changeQuote(char newQuote) throws BadQuoteException {
        if (this.quoteChar == newQuote) {
            return;
        }
        if (newQuote == '\n' || newQuote == '\r' || newQuote == this.delimiterChar || newQuote == this.quoteChar) {
            throw new BadQuoteException();
        }
        this.quoteChar = newQuote;
    }

    @Override
    public void println(String value) {
        try {
            this.writeln(value);
        }
        catch (IOException iox) {
            this.error = true;
        }
    }

    @Override
    public void writeln(String value) throws IOException {
        try {
            this.write(value);
            this.writeln();
        }
        catch (IOException iox) {
            this.error = true;
            throw iox;
        }
    }

    @Override
    public void println() {
        try {
            this.writeln();
        }
        catch (IOException iox) {
            this.error = true;
        }
    }

    @Override
    public void writeln() throws IOException {
        try {
            this.out.write("\n");
            if (this.autoFlush) {
                this.flush();
            }
            this.newLine = true;
        }
        catch (IOException iox) {
            this.error = true;
            throw iox;
        }
    }

    @Override
    public void println(String[] values) {
        try {
            this.writeln(values);
        }
        catch (IOException iox) {
            this.error = true;
        }
    }

    @Override
    public void writeln(String[] values) throws IOException {
        try {
            this.print(values);
            this.writeln();
        }
        catch (IOException iox) {
            this.error = true;
            throw iox;
        }
    }

    @Override
    public void print(String[] values) {
        try {
            this.write(values);
        }
        catch (IOException iox) {
            this.error = true;
        }
    }

    @Override
    public void write(String[] values) throws IOException {
        try {
            for (int i = 0; i < values.length; ++i) {
                this.write(values[i]);
            }
        }
        catch (IOException iox) {
            this.error = true;
            throw iox;
        }
    }

    @Override
    public void println(String[][] values) {
        try {
            this.writeln(values);
        }
        catch (IOException iox) {
            this.error = true;
        }
    }

    @Override
    public void writeln(String[][] values) throws IOException {
        try {
            for (int i = 0; i < values.length; ++i) {
                this.writeln(values[i]);
            }
            if (values.length == 0) {
                this.writeln();
            }
        }
        catch (IOException iox) {
            this.error = true;
            throw iox;
        }
    }

    @Override
    public void printlnComment(String comment) {
        this.println();
    }

    @Override
    public void writelnComment(String comment) throws IOException {
        this.writeln();
    }

    @Override
    public void print(String value) {
        try {
            this.write(value);
        }
        catch (IOException iox) {
            this.error = true;
        }
    }

    @Override
    public void write(String value) throws IOException {
        try {
            if (value == null) {
                value = "";
            }
            boolean quote = false;
            if (this.alwaysQuote) {
                quote = true;
            } else if (value.length() > 0) {
                for (int i = 0; i < value.length(); ++i) {
                    char c = value.charAt(i);
                    if (c != this.quoteChar && c != this.delimiterChar && c != '\n' && c != '\r') continue;
                    quote = true;
                }
            } else if (this.newLine) {
                quote = true;
            }
            if (this.newLine) {
                this.newLine = false;
            } else {
                this.out.write(this.delimiterChar);
            }
            if (quote) {
                this.out.write(this.escapeAndQuote(value));
            } else {
                this.out.write(value);
            }
            if (this.autoFlush) {
                this.flush();
            }
        }
        catch (IOException iox) {
            this.error = true;
            throw iox;
        }
    }

    private String escapeAndQuote(String value) {
        String s = StringHelper.replace(value, String.valueOf(this.quoteChar), String.valueOf(this.quoteChar) + String.valueOf(this.quoteChar));
        return new StringBuffer(2 + s.length()).append(this.quoteChar).append(s).append(this.quoteChar).toString();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public boolean checkError() {
        try {
            if (this.error) {
                return true;
            }
            this.flush();
            if (this.error) {
                return true;
            }
            if (this.out instanceof PrintWriter) {
                this.error = ((PrintWriter)this.out).checkError();
            }
        }
        catch (IOException iox) {
            this.error = true;
        }
        return this.error;
    }

    @Override
    public void setAlwaysQuote(boolean alwaysQuote) {
        this.alwaysQuote = alwaysQuote;
    }

    @Override
    public void setAutoFlush(boolean autoFlush) {
        this.autoFlush = autoFlush;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void main(String[] args) {
        try {
            void var1_5;
            if (args.length > 0) {
                File f = new File(args[0]);
                if (f.exists()) throw new IOException("File already exists: " + args[0]);
                f.createNewFile();
                if (!f.canWrite()) throw new IOException("Could not open " + args[0]);
                FileOutputStream fileOutputStream = new FileOutputStream(f);
            } else {
                PrintStream printStream = System.out;
            }
            ExcelCSVPrinter p = new ExcelCSVPrinter((OutputStream)var1_5);
            p.print("unquoted");
            p.print("escaped\"quote");
            p.println("comma,comma");
            p.print("!quoted");
            p.print("!unquoted");
            p.print(" quoted");
            p.println("quoted ");
            p.print("one");
            p.print("");
            p.print("");
            p.print("");
            p.println("");
            p.println("two");
            p.print("\nthree\nline\n");
            p.println("\ttab");
            return;
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }
}

