/*
 * Decompiled with CFR 0.152.
 */
package com.Ostermiller.util;

import com.Ostermiller.util.BadDelimiterException;
import com.Ostermiller.util.BadQuoteException;
import com.Ostermiller.util.CSVPrint;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;

public class CSVPrinter
implements CSVPrint {
    protected boolean autoFlush = true;
    protected boolean alwaysQuote = false;
    protected boolean error = false;
    protected char delimiterChar = (char)44;
    protected char quoteChar = (char)34;
    protected Writer out;
    protected boolean newLine = true;
    protected char commentStart = (char)35;

    @Override
    public void changeDelimiter(char newDelimiter) throws BadDelimiterException {
        if (this.delimiterChar == newDelimiter) {
            return;
        }
        if (newDelimiter == '\n' || newDelimiter == '\r' || newDelimiter == this.delimiterChar || newDelimiter == this.quoteChar) {
            throw new BadDelimiterException();
        }
        this.delimiterChar = newDelimiter;
    }

    @Override
    public void changeQuote(char newQuote) throws BadQuoteException {
        if (newQuote == '\n' || newQuote == '\r' || newQuote == this.delimiterChar || newQuote == this.quoteChar) {
            throw new BadQuoteException();
        }
        this.quoteChar = newQuote;
    }

    public CSVPrinter(OutputStream out) {
        this.out = new OutputStreamWriter(out);
    }

    public CSVPrinter(Writer out) {
        this.out = out;
    }

    public CSVPrinter(OutputStream out, char commentStart) {
        this(out);
        this.commentStart = commentStart;
    }

    public CSVPrinter(Writer out, char commentStart) {
        this(out);
        this.commentStart = commentStart;
    }

    public CSVPrinter(Writer out, boolean alwaysQuote, boolean autoFlush) {
        this.out = out;
        this.setAlwaysQuote(alwaysQuote);
        this.setAutoFlush(autoFlush);
    }

    public CSVPrinter(Writer out, char commentStart, char quote, char delimiter) throws BadDelimiterException, BadQuoteException {
        this.out = out;
        this.commentStart = commentStart;
        this.changeQuote(quote);
        this.changeDelimiter(delimiter);
    }

    public CSVPrinter(Writer out, char commentStart, char quote, char delimiter, boolean alwaysQuote, boolean autoFlush) throws BadDelimiterException, BadQuoteException {
        this.out = out;
        this.commentStart = commentStart;
        this.changeQuote(quote);
        this.changeDelimiter(delimiter);
        this.setAlwaysQuote(alwaysQuote);
        this.setAutoFlush(autoFlush);
    }

    @Override
    public void println(String value) {
        try {
            this.writeln(value);
        }
        catch (IOException iox) {
            this.error = true;
        }
    }

    @Override
    public void writeln(String value) throws IOException {
        try {
            this.write(value);
            this.writeln();
        }
        catch (IOException iox) {
            this.error = true;
            throw iox;
        }
    }

    @Override
    public void println() {
        try {
            this.writeln();
        }
        catch (IOException iox) {
            this.error = true;
        }
    }

    @Override
    public void writeln() throws IOException {
        try {
            this.out.write("\n");
            if (this.autoFlush) {
                this.flush();
            }
            this.newLine = true;
        }
        catch (IOException iox) {
            this.error = true;
            throw iox;
        }
    }

    @Override
    public void println(String[] values) {
        try {
            this.writeln(values);
        }
        catch (IOException iox) {
            this.error = true;
        }
    }

    @Override
    public void writeln(String[] values) throws IOException {
        try {
            this.print(values);
            this.writeln();
        }
        catch (IOException iox) {
            this.error = true;
            throw iox;
        }
    }

    @Override
    public void print(String[] values) {
        try {
            this.write(values);
        }
        catch (IOException iox) {
            this.error = true;
        }
    }

    @Override
    public void write(String[] values) throws IOException {
        try {
            for (int i = 0; i < values.length; ++i) {
                this.write(values[i]);
            }
        }
        catch (IOException iox) {
            this.error = true;
            throw iox;
        }
    }

    @Override
    public void println(String[][] values) {
        try {
            this.writeln(values);
        }
        catch (IOException iox) {
            this.error = true;
        }
    }

    @Override
    public void writeln(String[][] values) throws IOException {
        try {
            for (int i = 0; i < values.length; ++i) {
                this.writeln(values[i]);
            }
            if (values.length == 0) {
                this.writeln();
            }
        }
        catch (IOException iox) {
            this.error = true;
            throw iox;
        }
    }

    @Override
    public void printlnComment(String comment) {
        try {
            this.writelnComment(comment);
        }
        catch (IOException iox) {
            this.error = true;
        }
    }

    @Override
    public void writelnComment(String comment) throws IOException {
        try {
            if (comment == null) {
                comment = "";
            }
            if (!this.newLine) {
                this.writeln();
            }
            this.out.write(this.commentStart);
            this.out.write(32);
            block6: for (int i = 0; i < comment.length(); ++i) {
                char c = comment.charAt(i);
                switch (c) {
                    case '\r': {
                        if (i + 1 < comment.length() && comment.charAt(i + 1) == '\n') {
                            ++i;
                        }
                    }
                    case '\n': {
                        this.writeln();
                        this.out.write(this.commentStart);
                        this.out.write(32);
                        continue block6;
                    }
                    default: {
                        this.out.write(c);
                    }
                }
            }
            this.writeln();
        }
        catch (IOException iox) {
            this.error = true;
            throw iox;
        }
    }

    @Override
    public void print(String value) {
        try {
            this.write(value);
        }
        catch (IOException iox) {
            this.error = true;
        }
    }

    @Override
    public void write(String value) throws IOException {
        try {
            if (value == null) {
                value = "";
            }
            boolean quote = false;
            if (this.alwaysQuote) {
                quote = true;
            } else if (value.length() > 0) {
                char c = value.charAt(0);
                if (this.newLine && (c < '0' || c > '9' && c < 'A' || c > 'Z' && c < 'a' || c > 'z')) {
                    quote = true;
                }
                if (c == ' ' || c == '\f' || c == '\t') {
                    quote = true;
                }
                for (int i = 0; i < value.length(); ++i) {
                    c = value.charAt(i);
                    if (c != this.quoteChar && c != this.delimiterChar && c != '\n' && c != '\r') continue;
                    quote = true;
                }
                if (c == ' ' || c == '\f' || c == '\t') {
                    quote = true;
                }
            } else if (this.newLine) {
                quote = true;
            }
            if (this.newLine) {
                this.newLine = false;
            } else {
                this.out.write(this.delimiterChar);
            }
            if (quote) {
                this.out.write(this.escapeAndQuote(value));
            } else {
                this.out.write(value);
            }
            if (this.autoFlush) {
                this.flush();
            }
        }
        catch (IOException iox) {
            this.error = true;
            throw iox;
        }
    }

    private String escapeAndQuote(String value) {
        int count = 2;
        block8: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': 
                case '\\': {
                    ++count;
                    continue block8;
                }
                default: {
                    if (c != this.quoteChar) continue block8;
                    ++count;
                }
            }
        }
        StringBuffer sb = new StringBuffer(value.length() + count);
        sb.append(this.quoteChar);
        block9: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                default: {
                    if (c == this.quoteChar) {
                        sb.append("\\" + this.quoteChar);
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append(this.quoteChar);
        return sb.toString();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public boolean checkError() {
        try {
            if (this.error) {
                return true;
            }
            this.flush();
            if (this.error) {
                return true;
            }
            if (this.out instanceof PrintWriter) {
                this.error = ((PrintWriter)this.out).checkError();
            }
        }
        catch (IOException iox) {
            this.error = true;
        }
        return this.error;
    }

    @Override
    public void setAutoFlush(boolean autoFlush) {
        this.autoFlush = autoFlush;
    }

    @Override
    public void setAlwaysQuote(boolean alwaysQuote) {
        this.alwaysQuote = alwaysQuote;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void main(String[] args) {
        try {
            void var1_5;
            if (args.length > 0) {
                File f = new File(args[0]);
                if (f.exists()) throw new IOException("File already exists: " + args[0]);
                f.createNewFile();
                if (!f.canWrite()) throw new IOException("Could not open " + args[0]);
                FileOutputStream fileOutputStream = new FileOutputStream(f);
            } else {
                PrintStream printStream = System.out;
            }
            CSVPrinter p = new CSVPrinter((OutputStream)var1_5);
            p.print("unquoted");
            p.print("un\\quoted");
            p.print("escaped\"quote");
            p.print("escaped\"quote\\");
            p.println("comma,comma");
            p.print("!quoted");
            p.print("!unquoted");
            p.print(" quoted");
            p.print("quoted ");
            p.printlnComment("A comment.");
            p.print("one");
            p.print("");
            p.print("");
            p.print("");
            p.print("");
            p.printlnComment("Multi\nLine\rComment\r\nto test line breaks\r");
            p.println("two");
            p.printlnComment("Comment after explicit new line.");
            p.print("\nthree\nline\n");
            p.println("\ttab");
            return;
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }
}

