/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.cef.htmlpages;

import fr.exemole.bdfext.cef.htmlpages.PersonneAtelierParFonction;
import fr.exemole.bdfext.cef.htmlpages.PersonneAtelierParFonctionMap;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import java.text.ParseException;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.croisement.Croisements;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.misc.ThesaurusMessageLocalisation;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.instruction.InstructionResolver;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangPreference;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.logging.ErrorMessageException;

public class RecapitulatifGabaritResolver
implements InstructionResolver {
    private static final String LISTE_PREFIX = "LISTE_";
    private static final SubsetKey atelier2007CorpusKey = SubsetKey.build((String)"corpus_atelier");
    private static final SubsetKey atelier2009CorpusKey = SubsetKey.build((String)"corpus_atelier2009");
    private static final SubsetKey atelier2010CorpusKey = SubsetKey.build((String)"corpus_atelier2010");
    private static final SubsetKey personneatelier2009CorpusKey = SubsetKey.build((String)"corpus_personneatelier2009");
    private static final SubsetKey personneatelier2010CorpusKey = SubsetKey.build((String)"corpus_personneatelier2010");
    private static final SubsetKey personneCorpusKey = SubsetKey.build((String)"corpus_personne");
    private static final SubsetKey fonctionThesaurusKey = SubsetKey.build((String)"thesaurus_fonction0809");
    private final BdfServer bdfServer;
    private final Lang workingLang;
    private final Motcle atelier;
    private final Fichotheque fichotheque;
    private final Corpus atelier2007Corpus;
    private final Corpus atelier2009Corpus;
    private final Corpus atelier2010Corpus;
    private final Corpus personneatelier2009Corpus;
    private final Corpus personneatelier2010Corpus;
    private final Corpus personneCorpus;
    private final FicheMeta atelier2007;
    private final FicheMeta atelier2009;
    private final FicheMeta atelier2010;
    private final Thesaurus fonctionThesaurus;
    private final InternalBdfHtmlProducer hp;

    public RecapitulatifGabaritResolver(BdfServer bdfServer, Lang workingLang, Motcle atelier) {
        this.bdfServer = bdfServer;
        this.atelier = atelier;
        this.workingLang = workingLang;
        this.fichotheque = bdfServer.getFichotheque();
        this.atelier2007Corpus = (Corpus)this.fichotheque.getSubset(atelier2007CorpusKey);
        this.atelier2009Corpus = (Corpus)this.fichotheque.getSubset(atelier2009CorpusKey);
        this.atelier2010Corpus = (Corpus)this.fichotheque.getSubset(atelier2010CorpusKey);
        this.personneatelier2009Corpus = (Corpus)this.fichotheque.getSubset(personneatelier2009CorpusKey);
        this.personneatelier2010Corpus = (Corpus)this.fichotheque.getSubset(personneatelier2010CorpusKey);
        this.atelier2007 = this.getFirstFiche(this.atelier2007Corpus);
        this.atelier2009 = this.getFirstFiche(this.atelier2009Corpus);
        this.atelier2010 = this.getFirstFiche(this.atelier2010Corpus);
        this.personneCorpus = (Corpus)this.fichotheque.getSubset(personneCorpusKey);
        this.fonctionThesaurus = (Thesaurus)this.fichotheque.getSubset(fonctionThesaurusKey);
        Thesaurus thesaurus = FichothequeUtils.getThesaurus((Fichotheque)this.fichotheque, (String)"tableauloc");
        LangPreference langPreference = LocalisationUtils.toLangPreference((Lang)workingLang);
        this.hp = new InternalBdfHtmlProducer(bdfServer, langPreference);
        this.hp.addMessageLocalisation(bdfServer.getL10nManager().getMessageLocalisation(langPreference));
        this.hp.addMessageLocalisation((MessageLocalisation)new ThesaurusMessageLocalisation(thesaurus, workingLang, bdfServer.getThesaurusLangChecker(), workingLang.toLocale()));
    }

    private FicheMeta getFirstFiche(Corpus corpus) {
        Croisements ficheCroisements = this.fichotheque.getCroisements((SubsetItem)this.atelier, (Subset)corpus);
        return (FicheMeta)ficheCroisements.getFirstSubsetItem();
    }

    public Object resolve(Instruction instruction) throws ErrorMessageException {
        String name = ((Argument)instruction.get(0)).getKey();
        if (name.equals("ATELIER")) {
            StringBuilder buf = new StringBuilder();
            buf.append(this.atelier.getIdalpha());
            buf.append(" \u2013 ");
            buf.append(this.atelier.getLabelString(this.workingLang));
            return buf.toString();
        }
        if (name.equals("RECAP2007")) {
            if (this.atelier2007 == null) {
                return "<p><em>Pas d'atelier en 2007</em></p>";
            }
            return this.getRecap2007();
        }
        if (name.equals("RECAP2009")) {
            if (this.atelier2009 == null) {
                return "<p><em>Pas d'atelier en 2009</em></p>";
            }
            return this.getRecap2009();
        }
        if (name.equals("RECAP2010")) {
            if (this.atelier2010 == null) {
                return "<p><em>Pas d'atelier en 2010</em></p>";
            }
            return this.getRecap2010();
        }
        if (name.startsWith(LISTE_PREFIX)) {
            Corpus corpus = this.getCorpus(name.substring(LISTE_PREFIX.length()));
            if (corpus == null) {
                return "#Corpus inconnu : " + name + "#";
            }
            return this.getListeValue(corpus);
        }
        return null;
    }

    private String getListeValue(Corpus corpus) {
        Croisements ficheCroisements = this.fichotheque.getCroisements((SubsetItem)this.atelier, (Subset)corpus);
        if (ficheCroisements.isEmpty()) {
            return "";
        }
        this.hp.H3().__escape((CharSequence)FichothequeUtils.getTitle((Subset)corpus, (Lang)this.workingLang)).__space().CODE().__escape('[').__append(ficheCroisements.getEntryList().size()).__escape(']')._CODE()._H3();
        this.hp.UL();
        for (Croisements.Entry entry : ficheCroisements.getEntryList()) {
            this.appendLi((FicheMeta)entry.getSubsetItem());
        }
        this.hp._UL();
        return this.hp.flushString();
    }

    private String getRecap2007() {
        this.hp.P().__escape((CharSequence)"Atelier en 2007 : ").A(HA.href((CharSequence)("../../fiches/atelier-" + this.atelier2007.getId() + ".html"))).__escape((CharSequence)this.atelier2007.getTitre())._A()._P();
        this.hp.P().__escape((CharSequence)"Participants : ")._P();
        Croisements ficheCroisements = this.fichotheque.getCroisements((SubsetItem)this.atelier2007, (Subset)this.personneCorpus);
        this.hp.UL();
        for (Croisements.Entry entry : ficheCroisements.getEntryList()) {
            this.appendLi((FicheMeta)entry.getSubsetItem());
        }
        this.hp._UL();
        return this.hp.flushString();
    }

    private String getRecap2009() {
        Croisements croisements = this.fichotheque.getCroisements((SubsetItem)this.atelier, (Subset)this.personneatelier2009Corpus);
        if (!croisements.isEmpty()) {
            this.printPersonneAtelierList(croisements, this.personneatelier2009Corpus);
        }
        return this.hp.flushString();
    }

    private String getRecap2010() {
        Croisements croisements = this.fichotheque.getCroisements((SubsetItem)this.atelier, (Subset)this.personneatelier2010Corpus);
        if (!croisements.isEmpty()) {
            this.printPersonneAtelierList(croisements, this.personneatelier2010Corpus);
        }
        return this.hp.flushString();
    }

    private void printPersonneAtelierList(Croisements list, Corpus personneatelierCorpus) {
        PersonneAtelierParFonctionMap map = new PersonneAtelierParFonctionMap(personneatelierCorpus, this.fonctionThesaurus);
        map.build(list);
        this.hp.UL();
        for (PersonneAtelierParFonction papf : map.getFonctionMap().values()) {
            Motcle fonction = papf.getFonction();
            this.hp.LI();
            this.hp.DIV();
            this.printMotcle(fonction);
            this.hp._DIV();
            this.hp.UL();
            papf.printSimpleLists((HtmlPrinter)this.hp);
            this.hp._UL();
            this.hp._LI();
        }
        this.hp._UL();
    }

    public void printMotcle(Motcle motcle) {
        this.hp.__escape(motcle.getIdalpha()).__escape((CharSequence)" - ").__escape((CharSequence)motcle.getLabelString(this.workingLang));
    }

    private void appendLi(FicheMeta ficheMeta) {
        this.hp.LI().A(HA.href((CharSequence)("../../fiches/" + ficheMeta.getSubsetName() + "-" + ficheMeta.getId() + ".html"))).__escape((CharSequence)ficheMeta.getTitre())._A()._LI();
    }

    private Corpus getCorpus(String s) {
        try {
            SubsetKey corpusKey = SubsetKey.parse((String)s);
            return (Corpus)this.fichotheque.getSubset(corpusKey);
        }
        catch (ParseException pe) {
            return null;
        }
    }

    private static class InternalBdfHtmlProducer
    extends BdfServerHtmlProducer {
        private StringBuilder stringBuilder;

        private InternalBdfHtmlProducer(BdfServer bdfServer, LangPreference langPreference) {
            super(bdfServer, langPreference);
            this.init();
        }

        private void init() {
            this.stringBuilder = new StringBuilder();
            this.initPrinter(this.stringBuilder);
        }

        public String flushString() {
            String s = this.stringBuilder.toString();
            this.init();
            return s;
        }

        public void printHtml() {
        }
    }
}

