/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.cef.htmlpages;

import fr.exemole.bdfext.cef.htmlpages.CefHtmlPage;
import fr.exemole.bdfext.cef.htmlpages.CefHtmlPrinter;
import fr.exemole.bdfext.cef.htmlpages.PersonneAtelierParFonction;
import fr.exemole.bdfext.cef.htmlpages.PersonneAtelierParFonctionMap;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.users.BdfUser;
import java.util.List;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.croisement.Croisements;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.html.HtmlPrinter;

public class HierarchiePage
extends CefHtmlPage {
    private final Thesaurus hierarchie = this.getThesaurus("hierarchie");
    private final Thesaurus atelierThesaurus;
    private final Thesaurus fonctionThesaurus = this.getThesaurus("fonction0809");
    private final Corpus atelierCorpus = this.getCorpus("atelierpermanent");
    private final Corpus personneatelierCorpus;
    private final String mode;

    public HierarchiePage(BdfServer bdfServer, BdfUser bdfUser, String mode) {
        super(bdfServer, bdfUser);
        this.atelierThesaurus = this.getThesaurus("atelierpermanent");
        this.personneatelierCorpus = this.getCorpus("personneatelier2010");
        this.mode = mode;
    }

    @Override
    public CefHtmlPrinter getCefHtmlPrinter() {
        return new HierarchiePrinter();
    }

    private class HierarchiePrinter
    extends CefHtmlPrinter {
        private HierarchiePrinter() {
        }

        @Override
        public void printPage() {
            this.start(HierarchiePage.this.workingLang, "CEF");
            List motcleList = HierarchiePage.this.hierarchie.getFirstLevelList();
            this.printList(motcleList);
            this.end();
        }

        public void printMotcle(Motcle motcle) {
            this.__escape(motcle.getIdalpha()).__escape((CharSequence)" - ").__escape((CharSequence)motcle.getLabelString(HierarchiePage.this.workingLang));
        }

        private void printList(List<Motcle> motcleList) {
            this.UL();
            for (Motcle hierarchieItem : motcleList) {
                Croisements croisements = HierarchiePage.this.fichotheque.getCroisements((SubsetItem)hierarchieItem, (Subset)HierarchiePage.this.atelierCorpus);
                this.LI();
                this.DIV();
                this.printMotcle(hierarchieItem);
                this._DIV();
                if (!croisements.isEmpty()) {
                    this.printAtelierList(croisements);
                }
                this.printList(hierarchieItem.getChildList());
                this._LI();
            }
            this._UL();
        }

        private void printAtelierList(Croisements croisements) {
            this.UL();
            for (Croisements.Entry entry : croisements.getEntryList()) {
                this.printAtelier(entry.getSubsetItem().getId());
            }
            this._UL();
        }

        private void printAtelier(int motcleid) {
            Motcle atelier = HierarchiePage.this.atelierThesaurus.getMotcleById(motcleid);
            this.LI(HA.id((String)("ID_ATELIER_" + motcleid)));
            this.DIV();
            HtmlAttributes aAttributes = new HtmlAttributes();
            if (HierarchiePage.this.mode.equals("recapitulatif")) {
                aAttributes.href((CharSequence)("recap_atelier-" + atelier.getIdalpha() + ".html"));
                aAttributes.target("Edition");
            } else {
                aAttributes.href((CharSequence)("Atelier-" + atelier.getIdalpha()));
            }
            this.A(aAttributes);
            this.printMotcle(atelier);
            this._A();
            this._DIV();
            this._LI();
        }

        private void printPersonneAtelierList(Croisements croisements) {
            PersonneAtelierParFonctionMap map = new PersonneAtelierParFonctionMap(HierarchiePage.this.personneatelierCorpus, HierarchiePage.this.fonctionThesaurus);
            map.build(croisements);
            this.UL();
            for (PersonneAtelierParFonction papf : map.getFonctionMap().values()) {
                Motcle fonction = papf.getFonction();
                this.LI();
                this.DIV();
                this.printMotcle(fonction);
                this._DIV();
                this.UL();
                papf.printLists((HtmlPrinter)this);
                this._UL();
                this._LI();
            }
            this._UL();
        }
    }
}

